/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.client;

import dev.architectury.injectables.annotations.ExpectPlatform;
import earth.terrarium.chipped.client.forge.ChippedClientImpl;
import earth.terrarium.chipped.menus.ChippedScreen;
import earth.terrarium.chipped.registry.ModBlocks;
import earth.terrarium.chipped.registry.ModMenuTypes;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChippedClient {
    public static void init() {
        for (Supplier<Block> block : ModBlocks.CUTOUT_BLOCKS) {
            ChippedClient.registerBlockRenderType(RenderType.m_110463_(), block);
        }
        for (Supplier<Block> block : ModBlocks.TRANSPARENT_BLOCKS) {
            ChippedClient.registerBlockRenderType(RenderType.m_110466_(), block);
        }
        ChippedClient.registerBlockRenderType(RenderType.m_110463_(), ModBlocks.BOTANIST_WORKBENCH);
        ChippedClient.registerBlockRenderType(RenderType.m_110463_(), ModBlocks.GLASSBLOWER);
        ChippedClient.registerBlockRenderType(RenderType.m_110463_(), ModBlocks.CARPENTERS_TABLE);
        ChippedClient.registerBlockRenderType(RenderType.m_110463_(), ModBlocks.LOOM_TABLE);
        ChippedClient.registerBlockRenderType(RenderType.m_110463_(), ModBlocks.MASON_TABLE);
        ChippedClient.registerBlockRenderType(RenderType.m_110463_(), ModBlocks.ALCHEMY_BENCH);
        ChippedClient.registerBlockRenderType(RenderType.m_110463_(), ModBlocks.MECHANIST_WORKBENCH);
        ChippedClient.register(ModMenuTypes.ALCHEMY_BENCH.get(), ChippedScreen::new);
        ChippedClient.register(ModMenuTypes.BOTANIST_WORKBENCH.get(), ChippedScreen::new);
        ChippedClient.register(ModMenuTypes.CARPENTERS_TABLE.get(), ChippedScreen::new);
        ChippedClient.register(ModMenuTypes.GLASSBLOWER.get(), ChippedScreen::new);
        ChippedClient.register(ModMenuTypes.LOOM_TABLE.get(), ChippedScreen::new);
        ChippedClient.register(ModMenuTypes.MASON_TABLE.get(), ChippedScreen::new);
        ChippedClient.register(ModMenuTypes.MECHANIST_WORKBENCH.get(), ChippedScreen::new);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockRenderType(RenderType type, Supplier<Block> block) {
        void var1_1;
        ChippedClientImpl.registerBlockRenderType(type, (Supplier<Block>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <M extends AbstractContainerMenu, U extends Screen> void register(MenuType<? extends M> type, ScreenConstructor<M, U> factory) {
        void var1_1;
        ChippedClientImpl.register(type, var1_1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface ScreenConstructor<T extends AbstractContainerMenu, U extends Screen> {
        public U create(T var1, Inventory var2, Component var3);
    }
}

